/************************************************************************
 *
 * \file: UsbDeviceId.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * <brief description>.
 * <detailed description>
 * \component: Android Auto - Demo application
 *
 * \author: J. Harder / ADITG/SW1 / jharder@de.adit-jv.com
 *
 * \copyright (c) 2015 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 * \see <related items>
 *
 * \history
 *
 ***********************************************************************/

#ifndef AAUTOT_USBDEVICEID_H
#define AAUTOT_USBDEVICEID_H

#include <string>

namespace adit { namespace aauto {

class UsbDeviceId
{
public:
    UsbDeviceId(int inVendorId, const std::string& inSerial);

    bool operator==(const UsbDeviceId& inRight) const;
    inline bool operator!=(const UsbDeviceId& inRight) const
    { return !operator==(inRight); }

    bool operator<(const UsbDeviceId& inRight) const;
    inline bool operator>(const UsbDeviceId& inRight) const
    { return inRight.operator<(*this); }
    inline bool operator<=(const UsbDeviceId& inRight) const
    { return !operator>(inRight); }
    inline bool operator>=(const UsbDeviceId& inRight) const
    { return !operator<(inRight); }

private:
    int vendorId;
    std::string serial;
};

} } /* namespace adit { namespace aauto */

#endif /* AAUTOT_USBDEVICEID_H */
